<?php

use Carbon\Carbon;
use App\Models\City;
use App\Models\User;
use App\Models\Batch;
use App\Models\State;
use App\Models\Client;
use App\Models\Vendor;
use App\Models\Company;
use App\Models\Country;
use App\Models\Meeting;
use App\Models\Agreement;
use App\Models\Consultant;
use App\Models\Department;
use App\Models\GuestHouse;
use App\Models\Technology;
use App\Models\University;
use App\Models\Implementor;
use App\Models\VendorCompany;
use App\Models\ConsultantComment;

/* Find user is admin or not */
if (!function_exists('isAdmin')) {
	function isAdmin() {
		if(auth()->user()->hasAnyRole(['super_admin|admin|sub_admin'])) {
			return true;
		} else {
			return false;
		}
	}
}

/* Find user is admin or not */
if (!function_exists('isOpt')) {
	function isOpt() {
		if(auth()->user()->hasAnyRole(['opt_recruiter'])) {
			return true;
		} else {
			return false;
		}
	}
}

/* Find user is admin or not */
if (!function_exists('isOptLead')) {
	function isOptLead() {
		if(auth()->user()->hasAnyRole(['opt_team_lead'])) {
			return true;
		} else {
			return false;
		}
	}
}

/* Find user is admin or not */
if (!function_exists('isBenchsales')) {
	function isBenchsales() {
		if(auth()->user()->hasAnyRole(['benchsales_recruiter'])) {
			return true;
		} else {
			return false;
		}
	}
}

/* Find user is admin or not */
if (!function_exists('isBenchsalesLead')) {
	function isBenchsalesLead() {
		if(auth()->user()->hasAnyRole(['benchsales_team_lead'])) {
			return true;
		} else {
			return false;
		}
	}
}

/* User User ID's */
if (!function_exists('userUserIds')) {
	function userUserIds(int $id=NULL) {
		if(Auth::check()) {
			if($id == NULL) {
				$uuids = User::whereParent_id(auth()->user()->id)->pluck('id')->all();
				array_push($uuids, auth()->user()->id);
				return $uuids;
			} else {
				$uuids = User::whereParent_id($id)->pluck('id')->all();
				array_push($uuids, auth()->user()->id);
				return $uuids;
			}
		}
	}
}

/* Department Select */
if (!function_exists('departmentSelect')) {
	function departmentSelect() {
		return Department::pluck('name', 'id')->all();
	}
}

/* Company Select */
if (!function_exists('companySelect')) {
	function companySelect() {
		return Company::pluck('name', 'id')->all();
	}
}

/* Count latest meetings */
if (!function_exists('myMeetings')) {
	function myMeetings() {
		return Meeting::whereNotIn('status', [3])->limit(10)->get();
	}
}

/*SIDEBAR ACTIVE FUNCTIONS*/
if (!function_exists('activeMenu')) {
	function activeMenu($sideArray) {
		return (in_array(parse_url (url()->current())['path'], $sideArray))?'true':'false';
	}
}

if (!function_exists('activeMenuIcon')) {
	function activeMenuIcon($sideArray) {
		return (in_array(parse_url (url()->current())['path'], $sideArray))?'active':'collapsed';
	}
}

if (!function_exists('activeMenuActive')) {
	function activeMenuActive($sideArray) {
		return (in_array(parse_url (url()->current())['path'], $sideArray))?'show':'';
	}
}

if (!function_exists('activeSide')) {
	function activeSide($sideLink) {
		if(is_array($sideLink)) {
		return (in_array(parse_url (url()->current())['path'], $sideLink))?'active':'';
		} else {
		return (parse_url (url()->current())['path'] == $sideLink)?'active':'';
		}
	}
}
/*SIDEBAR FUNCTIONS ENDS*/

// Select Functions
if (!function_exists('countrySelect')) {
	function countrySelect() {
		$cntries = Country::pluck('name', 'id')->all();
		return array_merge(array('231' => 'USA', '101'=>'India'), $cntries);
	}
}

if (!function_exists('stateSelect')) {
	function stateSelect($id=null) {
		if(is_null($id)) {
			return State::whereCountry_id(231)->pluck('name', 'id')->all();
		} else {
			return State::whereCountry_id($id)->pluck('name', 'id')->all();
		}
	}
}

if (!function_exists('citySelect')) {
	function citySelect($id=null) {
		if(is_null($id)) {
			return City::whereState_id(3970)->pluck('name', 'id')->all();
		} else {
			return City::whereState_id($id)->pluck('name', 'id')->all();
		}
	}
}

if (!function_exists('technologySelect')) {
	function technologySelect($id=null) {
		return Technology::pluck('name', 'id')->all();
	}
}

if (!function_exists('universitySelect')) {
	function universitySelect($id=null) {
		return University::pluck('name', 'id')->all();
	}
}

if (!function_exists('clientSelect')) {
	function clientSelect($id=null) {
		return Client::pluck('name', 'id')->all();
	}
}

if (!function_exists('implementorSelect')) {
	function implementorSelect() {
		return Implementor::pluck('name', 'id')->all();
	}
}

if (!function_exists('vendorCompanySelect')) {
	function vendorCompanySelect() {
		return VendorCompany::pluck('name', 'id')->all();
	}
}

if (!function_exists('vendorSelect')) {
	function vendorSelect($id=null) {
		if(is_null($id)) {
			return Vendor::pluck('name', 'id')->all();
		} else {
			return Vendor::whereVendor_company_id($id)->pluck('name', 'id')->all();
		}
	}
}

if (!function_exists('guestHouseSelect')) {
	function guestHouseSelect() {
		return GuestHouse::whereColumn('capacity', '>', 'booked')->pluck('name', 'id')->all();
	}
}

if (!function_exists('redStar')) {
	function redStar() {
		print '<span class="RED-Star"> *</span>';
	}
}

if (!function_exists('userSelect')) {
	function userSelect($id=null) {
		if(is_null($id)) {
			return User::pluck('name', 'id')->all();
		} else {
			return User::whereDepartment_id($id)->pluck('name', 'id')->all();
		}
	}
}

if (!function_exists('batchSelect')) {
	function batchSelect() {
		return Batch::pluck('name', 'id')->all();
	}
}

if (!function_exists('dbDateFormat')) {
	function dbDateFormat($dt=null) {
		return date('Y-m-d', strtotime($dt));
	}
}

if (!function_exists('consultantSelect')) {
	function consultantSelect($id=null) {
		if(is_null($id)) {
			return Consultant::pluck('name', 'id')->all();
		} else {
			return Consultant::whereCreated_by($id)->pluck('name', 'id')->all();
		}
	}
}

if (!function_exists('quickRandom')) {
	function quickRandom($length = 16)
	{
		$pool = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';

		return substr(str_shuffle(str_repeat($pool, 5)), 0, $length);
	}
}

if (!function_exists('agreementSelect')) {
	function agreementSelect($id=null) {
		if(is_null($id)) {
			return Agreement::pluck('name', 'id')->all();
		} else {
			return Agreement::whereIn('user_id', $id)->pluck('name', 'id')->all();
		}
	}
}

if (!function_exists('roleSelect')) {
	function roleSelect() {
		return \DB::table('roles')->pluck('name', 'id')->all();
	}
}

if (!function_exists('roleUserSelect')) {
	function roleUserSelect($ids=null) {
		if(is_null($ids)) {
			return \DB::table('roles')->pluck('name', 'id')->all();
		} else {
			return User::whereHas("roles", function($q) use($ids){ $q->whereIn('name', $ids); })->pluck('name', 'id')->all();
		}
	}
}

if (!function_exists('dateDifference')) {
	function dateDifference($from, $to) {
		$datetime1 = new DateTime($from);
		$datetime2 = new DateTime($to);
		$interval = $datetime1->diff($datetime2);
		return $days = $interval->format('%a').' days';//now do whatever you like with $days
	}
}

if (!function_exists('addConsultantComment')) {
	function addConsultantComment($cid, $comment) {
		$ccmnt = new ConsultantComment;
        $ccmnt->consultant_id = $cid;
        $ccmnt->comment = ucwords($comment);
        $ccmnt->user_id = auth()->user()->id;
        $ccmnt->save();
	}
}

// Executing Curl
if (!function_exists('callCrl')) {
	function callCrl($url='', $options=[]) {
		$handle = curl_init();

		// Set the url
		curl_setopt($handle, CURLOPT_URL, $url);
		
		if ($options) {
			curl_setopt_array($handle, $options);
		}        
		
		$output = curl_exec($handle);
		
		curl_close($handle);

		return $output;
	}
}

if (!function_exists('loopChartData')){
    function loopChartData($account_details_name , $prefix = '',$chart_id ,$value = 0) {
        $name = trans('general.form.select.field', ['field' => trans_choice('accounting.account_name', 1)]);
        if($value != 1){
            $html  = "<option value='' class='special'>".$name ."</option>";
            $html .= "<option value='add_new' >Add New</option>";
        }else{
            $html = '';
        } 
        foreach ($account_details_name as $k=> $account) {  
        	if($chart_id == $account['id']){$select = 'selected' ; }else{ $select = ''; }
             $html .= "<option value=".$account['id']." data-subtext=".$account['account_name']." ".$select.">". 
                       $prefix . $account['name'] ; 
                    if (isset($account['children'])){
                    $html .=     loopChartData($account['children'],$prefix . $account['name'] ." : ",$chart_id,1);
                    }
             $html .= '</option>';
         }
     return $html; 
	}

}