<?php

namespace App\Exports;

use App\Models\CampaignContact;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\Exportable;

class CampaignContactCustomExport implements FromQuery
{
    use Exportable;

    public function __construct(int $list_id)
    {
        $this->list_id = $list_id;
    }

    public function query()
    {
        return CampaignContact::query()->whereList_id($this->list_id);
    }

    public function actions(Request $request)
    {
        return [
            (new DownloadExcel)->only('name', 'email', 'phone'),
        ];
    }
}
