<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use App\User;

class UserLog implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

       public $user;
    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(User $userdata)
    {   
        $this->user = $userdata;

    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new Channel('userlog');
    }
}
