<?php

namespace App\Events;
use App\Models\User;
use App\Models\Message;
use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;

class MessageSent implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;
    /**
     * User that sent the message
     *
     * @var User
     */
    public $user;

    /*Conversation ID
    */  
    public $conversation_id;
    /**
     * Message details
     *
     * @var Message
     */
    public $message;
    public $reciever;
    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(User $user, Message $message,$conversation_id,$reciever_id)
    {
        $this->user = $user;
        $this->message = $message;
        $this->conversation_id = $conversation_id;
        $this->reciever   = $reciever_id;
        $this->dontBroadcastToCurrentUser();
    }
    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new Channel('chat.'.$this->conversation_id);
    }

}
