<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Consultant;
use App\Models\ConsultantAging;
use Illuminate\Console\Command;
use App\Models\ConsultantIncentive;
use App\Models\IncentiveStructure;
use App\Models\UserIncentiveStructure;

class UpdateConsultantIncentives extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'update:incentives';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'This command updates monthly consultants incentives for users';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $joined_consultants = array_unique(ConsultantAging::whereActive(1)->whereStatus('in_job')->pluck('join_date', 'consultant_id')->all());
        $marketing_consultants = array_unique(ConsultantAging::whereActive(1)->whereIn('status', ['open_bench', 'on_bench'])->where( 'created_at', '<=', Carbon::now()->subDays(30))->pluck('consultant_id')->all());
        
        // Rendaring joined consultants
        foreach ($joined_consultants as $cid => $join_date) {
            // Check this month present in incentives or not
            $incentive_check = ConsultantIncentive::whereYear_id(date('Y'))->whereMonth_id(date('m'))->whereConsultant_id($cid)->first();
            
            $cuser = Consultant::whereId($cid)->first();
            if($cuser != '') {
                $user = $cuser->created_by;
                // User incentive
                $user_incentive = UserIncentiveStructure::whereUser_id($user)->whereStatus(1)->first();

                if($user_incentive != '') {
                    $structure = IncentiveStructure::find($user_incentive->incentive_structure_id);
                    $in_job_amount = $structure->in_job;
                    $in_job_recurr = $structure->in_job_recurr;
                    $job_bonus_amount = $structure->job_bonus;
                    $yearly_amount = $structure->yearly;

                    if($incentive_check != '') {
                        $incentive = ConsultantIncentive::whereYear_id(date('Y'))->whereMonth_id(date('m'))->whereConsultant_id($cid)->first();

                        if($incentive->in_job != 0) {
                            $in_job = $incentive->in_job + $in_job_amount;
                        } else {
                            $in_job = $incentive->in_job;
                        }
                        $incentive->in_job = $in_job;

                        if(date('Y-m', strtotime($incentive->join_date)) == date('Y-m')) {
                            $bonus = $incentive->job_bonus + $job_bonus_amount;
                        } else {
                            $bonus = $incentive->job_bonus;
                        }
                        $incentive->job_bonus = $bonus;

                        $incentive->update();
                    } else {
                        $consultant_incentive = new ConsultantIncentive;
                        $consultant_incentive->user_id = $user;
                        $consultant_incentive->consultant_id = $cid;
                        $consultant_incentive->year_id = date('Y');
                        $consultant_incentive->month_id = date('m');
                        $consultant_incentive->in_job = 1000;
                        if(date('Y-m', strtotime($join_date)) == date('Y-m')) {
                            $consultant_incentive->job_bonus = 15000;
                        }
                        $consultant_incentive->save();
                    }
                }
            }
        }

        // Rendaring marketing consultants
        foreach ($marketing_consultants as $cid) {
            // Check this month present in incentives or not
            $incentive_check = ConsultantIncentive::whereYear_id(date('Y'))->whereMonth_id(date('m'))->whereConsultant_id($cid)->first();
            
            $cuser = Consultant::whereId($cid)->first();
            if($cuser != '') {
                $user = $cuser->created_by;
                // User incentive
                $user_incentive = UserIncentiveStructure::whereUser_id($user)->whereStatus(1)->first();

                if($user_incentive != '') {                    
                    $structure = IncentiveStructure::find($user_incentive->incentive_structure_id);
                    $marketing_amount = $structure->marketing;
                    $marketing_recurr = $structure->marketing_recurr;

                    if($incentive_check != '') {
                        $incentive = ConsultantIncentive::whereYear_id(date('Y'))->whereMonth_id(date('m'))->whereConsultant_id($cid)->first();

                        if($incentive->marketing != 0) {
                            $marketing = $incentive->marketing + $marketing_amount;
                        } else {
                            $marketing = $incentive->marketing;
                        }
                        $incentive->marketing = $marketing;
                        $incentive->update();
                    } else {
                        $consultant_incentive = new ConsultantIncentive;
                        $consultant_incentive->user_id = $user;
                        $consultant_incentive->consultant_id = $cid;
                        $consultant_incentive->year_id = date('Y');
                        $consultant_incentive->month_id = date('m');
                        $consultant_incentive->marketing = 1000;
                        $consultant_incentive->save();
                    }
                }
            }
        }
    }
}
