<?php

namespace App\Classes;

use App\Models\Accounts\Accounting\Accounttypes;
use App\Models\Accounts\Accounting\Chartofaccounts;

class DepositType
{
    /**
     * Find Deposit Type By Giving Parameters
     * $account_id is From ac_chart_of_accounts
     * $type id CREDIT OR DEBIT
     */
    public static function find($account_id=null, $type=null)
    {
        $creditTypes = config('accounts.credit_types'); // (DEBIT  =+ && CREDIT =-)
        $debitTypes =  config('accounts.debit_types'); // (DEBIT =- && CREDIT=+)

        if($account_id) {
            $acc_type = Chartofaccounts::whereId($account_id)->first()->account_type_id;

            // IF PROCESS IS CREDIT
            if($type=='credit') {
                if(in_array($acc_type, $creditTypes)) {
                    return 'sub';
                }

                if(in_array($acc_type, $debitTypes)) {
                    return 'add';
                }

                if(!in_array($acc_type, $creditTypes) && !in_array($acc_type, $debitTypes)) {
                    return 'add';
                }
            }

            // IF PROCESS ID DEBIT
            if($type=='debit') {
                if(in_array($acc_type, $creditTypes)) {
                    return 'add';
                }

                if(in_array($acc_type, $debitTypes)) {
                    return 'sub';
                }

                if(!in_array($acc_type, $creditTypes) && !in_array($acc_type, $debitTypes)) {
                    return 'sub';
                }
            }

            // IF PROCESS NONE
            if($type != 'credit' && $type != 'debit') {
                return '';
            }
        }
    }
}