<?php

namespace App\Classes;

use DB;
use App\City;
use App\Models\User;
use App\Batch;
use App\State;
use App\Client;
use App\Vendor;
use App\Country;
use App\Student;
use App\Technology;
use App\University;
use App\Models\Company;
use App\Models\VendorCompany;
use Illuminate\Database\Eloquent\Model;

class CommonSelects extends Model
{
    /**
     * Roles Select
     */
    public static function roles($department_id=null)
    {
        if($department_id!=null) {
            return DB::table('roles')->whereDepartment_id($department_id)->pluck('display_name', 'id')->all();
        } else {
            return DB::table('roles')->pluck('display_name', 'id')->all();
        }
    }

    /**
     * Department Select
     */
    public static function departments()
    {
        return DB::table('departments')->pluck('department_name', 'id')->all();
    }

    /**
     * Country Select
     */
    public static function countries()
    {
        return Country::pluck('name', 'id')->all();
    }

    /**
     * State Select
     */
    public static function states($country_id = null)
    {
        if($country_id != null) {
            $c_id = $country_id;
        } else {
            $c_id = config('configurations.india_id');
        }

        return State::whereCountry_id($c_id)->pluck('name', 'id')->all();
    }

    /**
     * Citites Select
     */
    public static function cities(int $state_id = null)
    {
        if($state_id != null) {
            $s_id = $state_id;
        } else {
            $s_id = config('configurations.usa_state');
        }

        return City::whereState_id($s_id)->pluck('name', 'id')->all();
    }

    /**
     * Role Users
     * $role_id
     */
    public static function role_users($role_id = null)
    {
        if($role_id == null) {
            return User::whereActive(1)->pluck('name', 'id')->all();
        } else {
            return  User::join('role_user', 'role_user.user_id', '=', 'users.id')->where('users.active', '1')->whereIn('role_user.role_id', $role_id)->select('users.name as name', 'users.id as id')->pluck('name', 'id')->all();
        }
    }

    /**
     * Technologies Select
     */
    public static function technologies()
    {
        return Technology::pluck('name', 'id')->all();
    }

    /**
     * Batch Select
     */
    public static function batches()
    {
        return Batch::pluck('batch_name', 'id')->all();
    }

    /**
     * University Select
     */
    public static function universitites()
    {
        return University::pluck('name', 'id')->all();
    }

    /**
     * Client Select
     */
    public static function clients()
    {
        return Client::pluck('name', 'id')->all();
    }

    /**
     * Vendors Select
     */
    public static function vendors()
    {
        return Vendor::pluck('vendor_name', 'id')->all();
    }

    /**
     * Vendor Companies Select
     */
    public static function vendor_companies()
    {
        return VendorCompany::pluck('vendor_company_name', 'id')->all();
    }

    /**
     * Company Select
     */
    public static function companies()
    {
        return Company::pluck('name', 'id')->all();
    }

    /**
     * Users Select
     */
    public static function users($company_id=null)
    {
        if($company_id==null) {
            return  User::whereCompany_id(auth()->user()->company_id)->where('active', '1')->pluck('name', 'id')->all();
        } else {
            return  User::whereCompany_id($company_id)->where('active', '1')->pluck('name', 'id')->all();
        }
    }

    public static function employeesnotin($ids)
    {
        return User::whereNotIn('id', $ids)->pluck('name', 'id')->all();
    }

    /**
     * Guest Houses
     */
    public function guest_houses()
    {
        return Guesthouse::pluck('guesthouse_name', 'id')->all();
    }

    /**
     * Student
     */
    public static function students()
    {
        if(isAdmin()) {
            return Student::pluck('first_name', 'si_no')->all();
        } else if(isBenchsales()) {
            return Student::pluck('first_name', 'si_no')->all();
        } else {
            return Student::whereIn('opt_recruiter_id', userUserIds())->pluck('first_name', 'si_no')->all();
        }
    }
}
